/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.visualization.RegionVisualizationManager;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisualizationManager {
    public static final Logger VISUALIZATION_LOGGER = LogManager.getLogger((String)("yawp".toUpperCase() + "-Visualization"));
    public static final class_2960 REGION_BLOCK_DISPLAY_TAG = class_2960.method_60654((String)"yawp:region_block_display");
    public static final class_2960 REGION_TEXT_DISPLAY_TAG = class_2960.method_60654((String)"yawp:region_text_display");
    private static MinecraftServer serverInstance;
    private static final Map<class_2960, VisualizationManager> dimVisualizationManagers;
    private final Map<String, RegionVisualizationManager> regionDisplayManagers = new HashMap<String, RegionVisualizationManager>();

    public static void initServerInstance(MinecraftServer server) {
        serverInstance = server;
    }

    public static void nukeDisplayEntities(class_3218 level) {
        List entities = level.method_18198(class_5575.method_31795(class_8113.class), entity -> {
            boolean containsTextTag = entity.method_5752().contains(REGION_TEXT_DISPLAY_TAG.toString());
            boolean containsBlockTag = entity.method_5752().contains(REGION_BLOCK_DISPLAY_TAG.toString());
            return containsTextTag || containsBlockTag;
        });
        int entityAmount = entities.size();
        entities.forEach(e -> e.method_5650(class_1297.class_5529.field_26999));
        if (entityAmount > 0) {
            VISUALIZATION_LOGGER.info("Nuked all ({}) untracked region display entities in level {}.", (Object)entityAmount, (Object)level.method_27983().method_29177().toString());
        }
    }

    private VisualizationManager() {
    }

    public static void hideRegionsAround(class_1657 player, int radius) {
        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((class_5321<class_1937>)level.method_27983());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> {
                VisualizationManager.hide(region, DisplayType.FRAME);
                VisualizationManager.hide(region, DisplayType.HULL);
                VisualizationManager.hide(region, DisplayType.MINIMAL);
                VisualizationManager.hide(region, DisplayType.MARKED);
            });
        }
    }

    public static void showRegionsAround(class_1657 player, int radius, DisplayType displayType) {
        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((class_5321<class_1937>)level.method_27983());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> VisualizationManager.show(region, displayType));
        }
    }

    public static void hideAllRegions(class_1937 level, boolean untracked) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((class_5321<class_1937>)level.method_27983());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            Collection<IMarkableRegion> regions = dimApi.getAllLocalRegions();
            regions.forEach(region -> {
                VisualizationManager.hide(region, DisplayType.FRAME);
                VisualizationManager.hide(region, DisplayType.HULL);
                VisualizationManager.hide(region, DisplayType.MINIMAL);
                VisualizationManager.hide(region, DisplayType.MARKED);
            });
        }
        if (untracked) {
            VisualizationManager.nukeDisplayEntities((class_3218)level);
        }
    }

    public static void showTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.showTpAnchor(tpAnchor, level);
    }

    public static void hideTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.hideTpAnchor(tpAnchor, level);
    }

    public static void updateTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateTpAnchor(tpAnchor);
    }

    public static void showTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(anchor -> VisualizationManager.showTpAnchor(region, anchor));
    }

    public static void hideTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(anchor -> VisualizationManager.hideTpAnchor(region, anchor));
    }

    public static void show(IMarkableRegion region, DisplayType displayType, BlockDisplayProperties displayProperties) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.show(displayType, displayProperties, level);
    }

    private static VisualizationManager getOrCreateVisualizationManager(class_2960 levelRl) {
        if (!dimVisualizationManagers.containsKey(levelRl)) {
            VisualizationManager dimVm = new VisualizationManager();
            dimVisualizationManagers.put(levelRl, dimVm);
        }
        return dimVisualizationManagers.get(levelRl);
    }

    private static RegionVisualizationManager getOrCreateRegionVisualizationManager(VisualizationManager vm, IMarkableRegion region) {
        if (!vm.regionDisplayManagers.containsKey(region.getName())) {
            vm.regionDisplayManagers.put(region.getName(), new RegionVisualizationManager(region));
        }
        return vm.regionDisplayManagers.get(region.getName());
    }

    public static void show(IMarkableRegion region, DisplayType displayType) {
        VisualizationManager.show(region, displayType, region.getArea().getDisplay());
    }

    public static void hide(IMarkableRegion region, DisplayType displayType) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.hide(displayType);
    }

    public static void updateRegionDisplay(IMarkableRegion region) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.updateDisplay(region.getArea(), level);
    }

    public static void refreshDisplay(IMarkableRegion region, DisplayType displayType) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateDisplay(region.getArea().getDisplay(), displayType);
    }

    public static void refreshDisplay(IMarkableRegion region) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateDisplay(region.getArea().getDisplay(), true);
    }

    public static void showHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) {
            return;
        }
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (!(child instanceof IMarkableRegion)) continue;
            IMarkableRegion childRegion = (IMarkableRegion)child;
            VisualizationManager.show(childRegion, displayType);
            if (!recursive) continue;
            VisualizationManager.showHierarchy(childRegion, displayType, recursive);
        }
    }

    public static void showIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> VisualizationManager.show(intersectingRegion, displayType));
        }
    }

    public static void hideHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) {
            return;
        }
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (!(child instanceof IMarkableRegion)) continue;
            IMarkableRegion childRegion = (IMarkableRegion)child;
            VisualizationManager.hide(childRegion, displayType);
            if (!recursive) continue;
            VisualizationManager.hideHierarchy(childRegion, displayType, recursive);
        }
    }

    public static void hideIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> VisualizationManager.hide(intersectingRegion, displayType));
        }
    }

    static {
        dimVisualizationManagers = new HashMap<class_2960, VisualizationManager>();
    }
}

